//=============================================================================
// UT99 Extension Pack V1.0
// - Basic Edition -
// class by Shadow
// XTPhysicUtil, this class contains some physic/math functions often used
//=============================================================================
class XTPhysicUtil expands XTSystem abstract;


////-------------------------------////
////----------- General -----------////
////-------------------------------////

static function playerpawn getplayer(actor a)
{
	return class'XTMainUtil'.static.getlocalplayerfor(a);
}
static function vector SetBSPReflect(actor bsp,actor a,vector hitnormal,int maxreflects,float speed,int damage,pawn instigator,float momentum,bool bsound,sound impact)
{
	local vector v;
	local int numwhits;
	if(bsound)
	{
		a.playsound(Impact,slot_misc,2.0);
		a.makenoise(0.3);
	}
	if((Mover(bsp)!=None)&&Mover(bsp).bDamageTriggered)
	{
		bsp.TakeDamage(Damage,instigator,a.Location,Momentum*Normal(v),'');
		a.Destroy();
	}
	NumWHits++;
	a.SetTimer(0, False);
	if(NumWHits>maxreflects)a.Destroy();
	v-=2*(v dot HitNormal)*HitNormal;
	SetRoll(v,a);
	return v;
}

static function vector StuckOnBSP(vector hitnormal,actor a,float speed)
{
	local vector v;

	v=0.75*((v dot HitNormal )*HitNormal*(-0.25)+v);
	RandSpin(100000,a);
	speed=VSize(v);
	if ( v.z > 400)v.Z = 0.5 * (400 + v.Z);
	else if ( speed < 20 )a.SetPhysics(PHYS_None);
	return v;
}

static function vector SetBSPBounce(vector hitnormal,float bounceheight,float minfallspeed,out float speed,actor a)
{
	local vector v;
	v=0.8*((v dot HitNormal)*HitNormal*(-BounceHeight)+v);
	RandSpin(100000,a);
    speed=VSize(v);
	if(v.z>minfallspeed)v.Z=0.5*(minfallspeed+v.Z);
	else if(speed<20)
	{
		a.bBounce = False;
        a.SetPhysics(PHYS_None);
	}
	return v;
}

static function SetSimpleBounce(actor a,vector hitn)
{
	a.Velocity=0.9*((a.Velocity dot HitN)*HitN*(-2.0)+a.Velocity);
}

static function SetRoll(vector NewVelocity,actor a)
{
	local rotator newRot;
	newRot=rotator(NewVelocity);
	a.SetRotation(newRot);
}

static function vector SetBSPSlide(vector hitnormal,float speed,actor a)
{
	local vector v,v2;
	v2=v+mirrorvectorbynormal(v,hitnormal);
	a.setlocation(a.location+2.0*hitnormal);
	v=0.5*v2;
    a.acceleration*=0.5;
	v=vector(a.Rotation)*speed;
	v=VSize(v)*(normal(v)+0.05*normal(VRand()));
	return v;
}
static simulated final function RandSpin(float spinRate,actor a)
{
	a.DesiredRotation=RotRand();
	a.RotationRate=rot2(spinRate*2*FRand()-spinRate,spinRate*2*FRand()-spinRate,spinRate*2*FRand()-spinRate);
}  //ripped from projectile.uc =D

////-------------------------------////
////----------- Vectors -----------////
////-------------------------------////

static function vector Vect2(float x,float y,float z)
{
       return class'XTMainUtil'.static.vect2(x,y,z);
}
static function bool IsActorInRadius(vector a,vector b,bool bsmallerthan,float radius)
{
	local float dist;
	dist=vsize(a-b);
	if(bsmallerthan)
	{
		if(dist<radius)return false;
		else return true;
	}
	else
	{
		if(dist>radius)return false;
		else return true;
	}
}
static function SetGravityPoint(float f,float scale,float intensity,float radius,vector a,vector b,actor other)
{
	local vector suck;
	local float force;
	suck=a-b;
	force=f*(75*scale-vsize(suck));
	other.velocity+=-intensity*normal(suck)*force;
}
static final function vector AttractVel(actor a,actor b,float t,int intensity,float mag,vector velocity)
{
	local vector v;
	v=mag*normal(normal(b.location-a.location)*mag*t*Intensity+velocity);
	a.setrotation(rotator(a.velocity));
	return v;
}
////------------------------------////
////----------- Rotators ---------////
////------------------------------////

static function RandRotParam(out int param,int randrange)
{
	param=(param+rand(2*randrange+1)-randrange) & 0xFFFF;
}
static function rotator Rot2(int p,int y,int r)
{
	return class'XTMainUtil'.static.rot2(p,y,r);
}
static function RotRandomizer(out rotator randrotator,int rollrand,int yawrand,int pitchrand)
{
	randrotparam(randrotator.roll, rollrand);
	randrotparam(randrotator.yaw, yawrand);
	randrotparam(randrotator.pitch, pitchrand);
}
static function float RotSize(rotator r)
{
	return class'XTMainUtil'.static.rotsize(r);
}
static final function SetBeamDirection(actor act, out vector x,float a,float b, float c, float d, float e, float f)
{
	local vector y,z;
	act.getaxes(act.rotation,x,y,z);
	X.X+=(a*(d-frand()));
	X.Y+=(b*(e-frand()));
	X.Z+=(c*(f-frand()));
	x=normal(x);
	act.setrotation(rotator(x));
}

////---------------------------------------////
////-------- Interpolation/Movement -------////
////---------------------------------------////

static function bool UpdateDesiredPosition(actor Interpolated,float DeltaSeconds,vector BaseLoc,rotator BaseRot,vector DesLoc,rotator DesRot)
{
	local vector DeltaLoc;
	local rotator DeltaRot;
	local bool bReachedDestination;
	DeltaLoc=DesLoc-BaseLoc;
	DeltaRot=DesRot-BaseRot;
	bReachedDestination = (VSize(DeltaLoc)<=10&&RotSize(DeltaRot)<=100);
	interpolated.SetLocation(BaseLoc+(DeltaLoc*DeltaSeconds));
	interpolated.SetRotation(BaseRot+(DeltaRot*DeltaSeconds));
	return bReachedDestination;
}
static function Attach(actor b,vector base,rotator r,vector offset,float parameter)
{
	b.setlocation(offset+base+vector(r)*parameter);
	b.setrotation(r);
}
static function BeamAttach(actor a,vector base,rotator r,float parameter,bool bwithindex,optional float coefficent,optional int index)
{
	if(!bwithindex)a.setlocation(base+vector(r)*parameter);
	else a.setlocation(base+vector(r)*(parameter*coefficent*index));
}
static function vector BeamVect(vector base,rotator r,float parameter,bool bwithindex,optional float coefficent,optional int index)
{
	if(!bwithindex)return base+vector(r)*parameter;
	else return base+vector(r)*(parameter+coefficent*index);
}

////---------------------------------------////
////-------- Formulas/Physical Laws -------////
////---------------------------------------////
static function vector LawOfReflection(actor bsp,actor a,int maxreflects,vector hitnormal,float speed,int damage,pawn instigator,float momentum,name dtype,bool bsound,sound impact)
{
	local vector vel2d,norm2d,v;
	local int numwhits;
	v=vector(a.rotation)*speed;
	if(bsound)a.PlaySound(Impact,SLOT_Misc,2.0);
	if ((Mover(bsp)!=None)&&Mover(bsp).bDamageTriggered )
	{
		bsp.TakeDamage(damage,instigator,a.location,Momentum*Normal(v),dType);
		a.Destroy();
	}
	NumWHits++;
	a.SetTimer(0, False);
	a.MakeNoise(0.3);
	if(numwhits>maxreflects)a.Destroy();
	if(NumWHits==1)
	{
		Vel2D=v;
		Vel2D.Z=0;
		Norm2D=HitNormal;
		Norm2D.Z=0;
		Norm2D=Normal(Norm2D);
		Vel2D=Normal(Vel2D);
		if((Vel2D Dot Norm2D)< -0.999)
		{
			HitNormal=Normal(HitNormal+0.6*Vel2D);
			Norm2D=HitNormal;
			Norm2D.Z=0;
			Norm2D=Normal(Norm2D);
			if((Vel2D Dot Norm2D)<-0.999)
			{
				if (Rand(1)==0)HitNormal=HitNormal+vect(0.05,0,0);
				else HitNormal=HitNormal-vect(0.05,0,0);
				if (Rand(1)==0)HitNormal=HitNormal+vect(0,0.05,0);
				else HitNormal=HitNormal-vect(0,0.05,0);
				HitNormal=Normal(HitNormal);
			}
		}
	}
	v-=2*(v dot HitNormal)*HitNormal;
	SetRoll(v,a);
	return v;
}

////---------- Collision ---------////
static final function bool IsVectorInRadius(vector Origin,float Radius,vector temp,optional bool bignorez)
{
	local vector Difference;
	local float Dist;
	Difference=Temp-Origin;		
	if(bignorez)Difference.z=0;
	Dist=VSize(Difference);
	return(Dist<=Radius);
}

defaultproperties
{
}
